IF OBJECT_ID('P_EST_NF_SAI_NUMERACAO_REFAZER') IS NOT NULL
	BEGIN
		DROP PROCEDURE [dbo].[P_EST_NF_SAI_NUMERACAO_REFAZER]
	END
GO
--EXEC P_EST_NF_SAI_NUMERACAO_REFAZER 1, 4, 9428,
CREATE PROCEDURE [dbo].[P_EST_NF_SAI_NUMERACAO_REFAZER] (@CD_EMP INT, @CD_FILIAL INT, @CD_NF INT, @CD_NF_SERIE INT=0)
AS
DECLARE @DT_EMI_NF DATETIME
DECLARE @NF_NF INT
SET NOCOUNT ON 
CREATE TABLE #NOTAFISCAIS (CD_EMP INT, CD_FILIAL INT, CD_NF INT, NF_NF_NOVO INT)

IF @CD_NF_SERIE=0
begin
SELECT
	@CD_NF_SERIE=CD_NF_SERIE
FROM
	EST_NF_SAI 
WHERE
	CD_EMP =@CD_EMP
	AND CD_FILIAL = @CD_FILIAL
	AND CD_NF = @CD_NF
end

SET @NF_NF=(SELECT
			ISNULL(MAX(NR_NF),0) 
			FROM
				EF_NF_CTR_NR
			WHERE
				CD_EMP =@CD_EMP
				AND CD_FILIAL = @CD_FILIAL
				AND CD_NF_SERIE=@CD_NF_SERIE)

PRINT 'Novo numero.: ' + convert(varchar(20),@NF_NF + 1)

--Inserindo notas fiscais para tratamento
INSERT INTO #NOTAFISCAIS
SELECT
	EST_NF_SAI.CD_EMP,
	EST_NF_SAI.CD_FILIAL,
	EST_NF_SAI.CD_NF,
	@NF_NF + ROW_NUMBER() OVER (PARTITION BY EST_NF_SAI.CD_EMP, 
									EST_NF_SAI.CD_FILIAL
									ORDER BY EST_NF_SAI.CD_EMP, 
									EST_NF_SAI.CD_FILIAL) AS CD_IT
FROM
	EST_NF_SAI 
WHERE
	EST_NF_SAI.CD_EMP=@CD_EMP 
	AND EST_NF_SAI.CD_FILIAL=@CD_FILIAL
	AND EST_NF_SAI.CD_NF=@CD_NF

--Controle de numeracao
INSERT INTO EF_NF_CTR_NR (CD_EMP,CD_FILIAL,NR_NF,CD_NF_SERIE,NR_SELO_SAIDA,DT_CAD)
SELECT
	CD_EMP,
	CD_FILIAL,
	NF_NF_NOVO,
	@CD_NF_SERIE,
	0,
	GETDATE()
FROM
	#NOTAFISCAIS

--Update novo numero
UPDATE
	e
SET 
	NF_NF = NF_NF_NOVO,
	STS_NF=0,
	DT_EMI_NF=CONVERT(CHAR(10),GETDATE(),112),
	HR_EMI_NF=CONVERT(CHAR(8),GETDATE(),108)
FROM
	EST_NF_SAI e INNER JOIN #NOTAFISCAIS N	ON
	e.CD_EMP = N.CD_EMP AND
	e.CD_FILIAL = N.CD_FILIAL AND
	e.CD_NF = N.CD_NF 

UPDATE
	e
SET 
	DT_EMI_NF=CONVERT(CHAR(10),GETDATE(),112)
FROM
	EST_NF_SAI_IT e INNER JOIN #NOTAFISCAIS N	ON
	e.CD_EMP = N.CD_EMP AND
	e.CD_FILIAL = N.CD_FILIAL AND
	e.CD_NF = N.CD_NF 

--Deletando vinculo com inutilizacao
DELETE
	EST_NF_SAI_EST_NF_NFE_INU
WHERE
	CD_EMP=@CD_EMP 
	AND CD_FILIAL=@CD_FILIAL
	AND CD_NF=@CD_NF

--Deletando pendencia
DELETE
	EST_NF_SAI_NFE_PEND
WHERE
	CD_EMP=@CD_EMP 
	AND CD_FILIAL=@CD_FILIAL
	AND CD_NF=@CD_NF

--Inserindo pendencia	
INSERT INTO EST_NF_SAI_NFE_PEND(CD_EMP,CD_FILIAL,CD_NF,DT_CAD,PEND_SOLUC)
SELECT
	@CD_EMP,
	@CD_FILIAL,
	@CD_NF,
	GETDATE(),
	0

DROP TABLE #NOTAFISCAIS
GO


